// qirc_dll.cpp : Defines the entry point for the DLL application.
//

#include <windows.h>
#include <stdio.h>

// globaler console buffer ca. 8KB
char console[8000];

BOOL CALLBACK SendCommand( HWND hwnd, LPARAM lParam)
{
	char className[1024];
	char * command = (char*)lParam;	// bernimm parameter

	GetClassName(hwnd,className,sizeof(className));

	if (strcmp("Edit",className)) return true;	// es muss ein editfeld sein
	
	if (ES_READONLY & GetWindowLong(hwnd,GWL_STYLE)) return true;	// auch nicht ein read only

	int length = strlen(command);
	if (length == 0) return false;

	// limit row length
	if (length>128) length = 128;
	
	// send every char
	for (int i = 0; i<length;i++)
		SendMessage(hwnd,WM_CHAR ,command[i],1);

	// and the CR 
	SendMessage(hwnd,WM_CHAR ,13,1);
		
	return false;
};

BOOL CALLBACK ScanString( HWND hwnd, LPARAM lParam)
{
	char className[1024];

	GetClassName(hwnd,className,sizeof(className));
	if (strcmp("Edit",className)) return true;	// es muss ein editfeld sein

	if (!(ES_READONLY & GetWindowLong(hwnd,GWL_STYLE))) return true;

	// hole consoleninhalt
	SendMessage(hwnd,WM_GETTEXT ,(WPARAM)sizeof(console),(LPARAM) console);

	return false;
};

BOOL CALLBACK ClearAll( HWND hwnd, LPARAM lParam)
{
	char className[1024];

	GetClassName(hwnd,className,sizeof(className));
	if (strcmp("Edit",className)) return true;	// es muss ein editfeld sein

	if (!(ES_READONLY & GetWindowLong(hwnd,GWL_STYLE))) return true;

	// lsche console
	SendMessage(hwnd,WM_SETTEXT ,(WPARAM)NULL,(LPARAM)"");
		
	return false;
};


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:// MessageBox(NULL,"Written by [UTG]LOKi\nhttp://argus.splatterworld.de","QIRC.DLL",MB_OK);break;
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:// MessageBox(NULL,"Unload DLL","QIRC",MB_OK);break;
			break;
    }
    return TRUE;
}

int __declspec(dllexport) FAR PASCAL SendConsole(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	HWND hwnd = FindWindow("Q3 WinConsole","Quake 3 Console");
	
	if (hwnd)
		EnumChildWindows( hwnd,SendCommand,(LPARAM)data);
	
	return 1;
}

int __declspec(dllexport) FAR PASCAL ScanConsole(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	HWND hwnd = FindWindow("Q3 WinConsole","Quake 3 Console");
	char pattern[256];

	strcpy(pattern,data);
	int length = strlen(pattern);

	strcpy(data,"\0");
		
	if (hwnd && pattern[0])
	{

		memset(console,0,sizeof(console));	// console lschen
		// console in den buffer lesen
		EnumChildWindows(hwnd,ScanString,NULL);

		// wenn text leer ist wird die console gescannt
		char * start = console;
		char * end = NULL;
				
		while (end = strstr(start,"\xD\xA"))
		{
			*end = 0;
			// check if it is a console command, to avoid fakers
			if ( (start[0]==']') && (!strncmp(start+1,pattern,length) ) )
			{
				if (data[0]) strcat(data,"\xFF"); // seperator char 255
				strcat(data,start+length+2);
			}

			start=end+2;  // jump over CRLF
		}

		if ( (start[0]==']') && (!strncmp(start+1,pattern,length) ) )
			{
				if (data[0]) strcat(data,"\xFF"); // seperator char 255
				strcat(data,start+length+2);
			}
	}

	return 3;
}

int __declspec(dllexport) FAR PASCAL IsQuakeActive(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	if (FindWindow("Q3 WinConsole","Quake 3 Console"))
		strcpy(data,"TRUE");
	else
		strcpy(data,"FALSE");
	return 3;
}

int __declspec(dllexport) FAR PASCAL ClearConsole(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
{
	HWND hwnd = FindWindow("Q3 WinConsole","Quake 3 Console");
	
	if (hwnd)
		EnumChildWindows( hwnd,ClearAll,NULL);
	
	return 1;
}
